<?php
    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "../../componenti/include/includeBaseComponenti.php";
    // solo i super admin hanno accesso agli strumenti
    if($_SESSION["geecomAdmin_ruolo"]!="super admin") {
        header("Location: {$percorsoBase}index.php");
        exit();
    }
    
    $elementiPerPagina = 5; // costante usata per paginare i file csv di vario tipo
    $paginaCorrente    = isset($_GET["pag"]) ? filter_input(INPUT_GET, "pag",FILTER_SANITIZE_NUMBER_INT) : 1;
    $primoElemento     = isset($_GET["pag"]) ? $elementiPerPagina*($paginaCorrente-1) : 1;
    $ultimoElemento    = $primoElemento + $elementiPerPagina;
?>
<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <title>Amministrazione di Geecom CMS - strumento importa / esporta</title>

    <?php
        include "../../componenti/include/cssBaseComponenti.php";
    ?>
	  
  </head>
  <body>
    
    <?php  
        include "../../include/barraSuperiore.php";

        include "../../include/header.php";

        include "../../include/barraMenu.php";
        
    ?>
	  
    <main role="main" class="bg-light" id="main">
        <div id="dashboard" class="container-fluid">
                <div class="row">

                    <!-- Colonna principale -->
                    <div class="col-12 py-4" id="">

                        <?php 
                            if(isset($_GET["status"])) {
                                if($_GET["status"]==200) {
                                    echo"<p class=\"alert alert-success\">Importazione eseguita, sono stati importati {$_GET["numeroElementImportati"]} elementi</p>";
                                }
                                else if($_GET["status"]==396) {
                                        echo"<p class=\"alert alert-danger\">{$_GET["messaggio"]}</p>";
                                }
                                else { //status = 5
                                        echo"<p class=\"alert alert-success\">Utente eliminato</p>";
                                }
                            }
                        ?>
                                <div class="row mb-4">
                                        <div class="col-lg-6 col-xl-5">
                                                <div class="card mb-4 box-shadow-lite">
                                                        <div class="card-header">
                                                            <span class="card-title">
                                                                Importa
                                                            </span>
                                                        </div>
                                                        <div class="card-body">
                                                            <form name="formImportazione" action="../../../controller/controllerImportazioni.php" method="post" enctype="multipart/form-data">
                                                                <div class="form-group">
                                                                    <label>Cosa vuoi importare? </label>
                                                                    <select class="custom-select" id="tabellaImportazione" name="tabella" onchange="mostraSelectGruppi()">
                                                                        <option value="geec_categorie">Categorie</option>
                                                                        <option value="geec_configurazioniAspetto">Configurazioni aspetto</option>
                                                                        <option value="geecB_contenuti">Contenuti</option>
                                                                        <option value="geec_utenti">Utenti</option>
                                                                    </select>
                                                                </div>
                                                                <div id="divSelectGruppo" class="d-none">
                                                                    <label>Associare gli utenti ad un gruppo? </label>
                                                                    <select class="custom-select" name="gruppoAssociato" >
                                                                        <option value=0 selected>Nessun gruppo</option>
                                                                        <?php 
                                                                            $queryGruppi = "SELECT * FROM geec_gruppi";
                                                                            $risGruppi = $geecomDb->eseguiQueryLettura($queryGruppi);
                                                                            while($gruppi = $risGruppi->fetch_assoc()) {
                                                                                echo"<option value={$gruppi["id"]} >{$gruppi["nome"]}</option>";
                                                                            }
                                                                        ?>
                                                                    </select>
                                                                </div>
                                                                <div class="form-group">
                                                                    <div class="custom-file">
                                                                        <input type="file" class="custom-file-input" id="customFile" name="file" lang="it" accept=".csv" required>
                                                                        <label class="custom-file-label" for="customFile" data-browse="Sfoglia">Scegli un file</label>
                                                                    </div>
                                                                </div>
                                                                <div class="form-row">
                                                                    <div class="form-group col-md-6">
                                                                        <label for="italiano" class="d-block">Forza ID</label>
                                                                        <input type="checkbox" class="js-switch" name="forzaId" value="si" >
                                                                        <small class="d-block mt-2">Impostando questo campo gli elementi verranno importati con l'id presente nel file. <b>Attenzione: se nel database sono presenti id uguali verrà generato un errore.</b></small>
                                                                    </div>
                                                                    <div class="form-group col-md-6">
                                                                        <label for="italiano" class="d-block">Salta intestazione</label>
                                                                        <input type="checkbox" class="js-switch" name="saltaIntestazione" value="si">
                                                                        <small class="d-block mt-2">Se è selezionato Geecom comincerà a leggere il file dalla seconda riga</small>
                                                                    </div>
                                                                </div>
                                                                <hr>
                                                                <button type="submit" class="btn btn-primary float-right">Avvia importazione<i class="fas fa-file-import ml-2"></i></button>
                                                            </form>
                                                        </div>
                                                </div>
                                        </div>
                                        <div class="col-lg-6 col-xl-7">
                                            <div class="card mb-4 box-shadow-lite">
                                                <div class="card-header" >
                                                    <span class="card-title">
                                                        Esporta
                                                    </span>
                                                </div>
                                                <div class="card-body">
                                                    <div class="row">
                                                        <div class="col-6 col-lg-3 mb-5 mb-lg-0 text-center">
                                                            <a class="btn btn-primary btn-block" href="../../../controller/controllerEsportazioni.php?operazione=esportaTabella&tabella=geecB_contenuti">
                                                                <img src="../../../template/img/dash/icona_dash_Pagine.svg" class="w-50 mb-2">
                                                                <h6>Contenuti</h6>
                                                            </a>
                                                        </div>
                                                        <div class="col-6 col-lg-3 mb-5 mb-lg-0 text-center">
                                                            <a class="btn btn-primary btn-block" href="../../../controller/controllerEsportazioni.php?operazione=esportaTabella&tabella=geec_categorie">
                                                                <img src="../../../template/img/dash/icona_dash_Categorie.svg" class="w-50 mb-2">
                                                                <h6>Categorie</h6>
                                                            </a>
                                                        </div>
                                                        <div class="col-6 col-lg-3 mb-5 mb-lg-0 text-center">
                                                            <a class="btn btn-primary btn-block" href="../../../controller/controllerEsportazioni.php?operazione=esportaTabella&tabella=geec_utenti">
                                                                <img src="../../../template/img/dash/icona_dash_Utenti.svg" class="w-50 mb-2">
                                                                <h6>Utenti</h6>
                                                            </a>
                                                        </div>
                                                        <div class="col-6 col-lg-3 mb-5 mb-lg-0 text-center">
                                                            <a class="btn btn-primary btn-block" href="../../../controller/controllerEsportazioni.php?operazione=esportaTabella&tabella=geec_configurazioniAspetto">
                                                                <img src="../../../template/img/dash/icona_dash_Aspetto.svg" class="w-50 mb-2">
                                                                <h6>Aspetto</h6>
                                                            </a>
                                                        </div>
                                                        
                                                        <?php 
                                                            $queryComponente = "SELECT * FROM geecB_componenti WHERE nome LIKE 'Ecommerce'";
                                                            $risEcommerce    = $geecomDb->eseguiQueryLettura($queryComponente);

                                                            if($risEcommerce->num_rows>0) {
                                                        ?>
                                                                <div class="col-6 col-lg-3 mb-5 mb-lg-0 text-center mt-3">
                                                                    <a class="btn btn-primary btn-block" href="../../../controller/controllerEsportazioni.php?operazione=esportaTabella&tabella=geecEc_ordini">
                                                                        <img src="../../../template/img/dash/icona_ordini.svg" class="w-50 mb-2">
                                                                        <h6>Ordini</h6>
                                                                    </a>
                                                                </div>

                                                                <div class="col-6 col-lg-3 mb-5 mb-lg-0 text-center mt-3">
                                                                    <a class="btn btn-primary btn-block" href="../../../controller/controllerEsportazioni.php?operazione=esportaTabella&tabella=geecEc_prodotti">
                                                                        <img src="../../../template/img/dash/icona_prodotti.svg" class="w-50 mb-2">
                                                                        <h6>Prodotti</h6>
                                                                    </a>
                                                                </div>
                                                        <?php
                                                            }
                                                        ?>
                                                    </div>
                                                    <hr>
                                                    <h6>Ultimi CSV esportati:</h6>
                                                        <?php
                                                            $fileCsv= scandir("../../../file/csv");
                                                        ?>
                                                        <ul class="nav nav nav-tabs tabs-justified mt-3">
                                                          <li class="nav-item">
                                                                <a class="nav-link active" data-toggle="tab" href="#tabContenuti" role="tab" aria-controls="tabContenuti">Contenuti</a>
                                                          </li>
                                                          <li class="nav-item">
                                                                <a class="nav-link"  data-toggle="tab" href="#tabComunicazioni" role="tab" aria-controls="tabComunicazioni">Comunicazioni</a>
                                                          </li>
                                                          <li class="nav-item">
                                                                <a class="nav-link"  data-toggle="tab" href="#tabUtenti" role="tab" aria-controls="tabUtenti">Utenti</a>
                                                          </li>
                                                          <li class="nav-item">
                                                                <a class="nav-link" data-toggle="tab" href="#tabAspetto" role="tab" aria-controls="tabAspetto">Aspetto</a>
                                                          </li>
                                                        </ul>
                                                        <div class="tab-content" id="myTabContent">
                                                            <div class="tab-pane fade show active px-0" id="tabContenuti">
                                                                <table class="table">
                                                                    <thead>
                                                                        <tr>
                                                                            <th scope="col">Nome file</th>
                                                                            <th scope="col">Data</th>
                                                                            <th scope="col"></th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <?php 
                                                                            $contatore = 0;
                                                                            foreach($fileCsv as $file) {
                                                                                if($file!="." && $file!=".." && strpos($file,"_contenuti")>0) {
                                                                                    $contatore ++;
                                                                                    if($contatore>=$primoElemento && $contatore<=$ultimoElemento) {   
                                                                        ?>
                                                                                <tr>
                                                                                    <td><?php echo $file ?></td>
                                                                                    <td><?php echo date("d/m/Y H:i", filemtime("../../../file/csv/$file")); ?></td>
                                                                                    <td>
                                                                                        <div class="btn-group azioni" role="group" aria-label="Azioni">
                                                                                            <a class="btn visualizza" data-toggle="tooltip" data-placement="bottom" title="Scarica" href="<?php echo "../../../file/csv/$file" ?>"><i class="fas fa-download"></i></a>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                        <?php
                                                                                    }
                                                                                }
                                                                            }
                                                                        ?>
                                                                    </tbody>
                                                                </table>
                                                                <?php 
                                                                    $numeroFile = contaFile($fileCsv,"_contenuti");
                                                                    if($numeroFile>=$elementiPerPagina) {
                                                                        $totalePagine = round($numeroFile/$elementiPerPagina);
                                                                ?>
                                                                    <nav aria-label="Paginazione">
                                                                        <ul class="pagination">
                                                                            <li class="page-item disabled">
                                                                                <a class="page-link" href="#" aria-label="Previous">
                                                                                      <span aria-hidden="true">«</span>
                                                                                </a>
                                                                            </li>
                                                                            <?php 
                                                                                for($i=1;$i<=$totalePagine;$i++) {
                                                                            ?>
                                                                                    <li class="page-item <?php echo(($paginaCorrente==$i) ? "active" : "") ?>">
                                                                                        <a class="page-link" href="index.php?tipoFile=_contenuti&pag=<?php echo $i ?>"><?php echo $i ?></a>
                                                                                    </li>
                                                                            <?php
                                                                                }
                                                                            ?>
                                                                            <li class="page-item disabled">
                                                                                <a class="page-link" href="index.php?elementiPerPagina=25&amp;pag=.2" aria-label="Next">
                                                                                      <span aria-hidden="true">»</span>
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </nav>
                                                                <?php   
                                                                    }
                                                                ?>
                                                            </div>

                                                            <div class="tab-pane fade px-0" id="tabComunicazioni">
                                                                    <table class="table">
                                                                      <thead>
                                                                            <tr>
                                                                              <th scope="col">Nome file</th>
                                                                              <th scope="col">Data</th>
                                                                              <th scope="col"></th>
                                                                            </tr>
                                                                      </thead>
                                                                      <tbody>
                                                                        <?php 
                                                                            foreach($fileCsv as $file) {
                                                                                if($file!="." && $file!=".." && strpos($file,"_comunicazioni")>0) {
                                                                                    $contatore ++;
                                                                                    if($contatore>=$primoElemento && $contatore<=$ultimoElemento) {
                                                                                        
                                                                        ?>
                                                                                <tr>
                                                                                    <td><?php echo $file ?></td>
                                                                                    <td><?php echo date("d/m/Y H:i", filemtime("../../../file/csv/$file")); ?></td>
                                                                                    <td>
                                                                                        <div class="btn-group azioni" role="group" aria-label="Azioni">
                                                                                            <a class="btn visualizza" data-toggle="tooltip" data-placement="bottom" title="Scarica" href="<?php echo "../../../file/csv/$file" ?>"><i class="fas fa-download"></i></a>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                        <?php
                                                                                    }
                                                                                }
                                                                            }
                                                                        ?>
                                                                      </tbody>
                                                                    </table>
                                                                    <?php 
                                                                        $numeroFile = contaFile($fileCsv,"_comunicazioni");
                                                                        if($numeroFile>=$elementiPerPagina) {
                                                                            $totalePagine = round($numeroFile/$elementiPerPagina);
                                                                    ?>
                                                                        <nav aria-label="Paginazione">
                                                                            <ul class="pagination">
                                                                                <li class="page-item disabled">
                                                                                    <a class="page-link" href="#" aria-label="Previous">
                                                                                          <span aria-hidden="true">«</span>
                                                                                    </a>
                                                                                </li>
                                                                                <?php 
                                                                                    for($i=1;$i<=$totalePagine;$i++) {
                                                                                ?>
                                                                                        <li class="page-item <?php echo(($paginaCorrente==$i) ? "active" : "") ?>">
                                                                                            <a class="page-link" href="index.php?tipoFile=_comunicazioni&pag=<?php echo $i ?>"><?php echo $i ?></a>
                                                                                        </li>
                                                                                <?php
                                                                                    }
                                                                                ?>
                                                                                <li class="page-item disabled">
                                                                                    <a class="page-link" href="index.php?elementiPerPagina=25&amp;pag=.2" aria-label="Next">
                                                                                          <span aria-hidden="true">»</span>
                                                                                    </a>
                                                                                </li>
                                                                            </ul>
                                                                        </nav>
                                                                    <?php   
                                                                        }
                                                                    ?>
                                                            </div>
                                                            
                                                            <div class="tab-pane fade px-0" id="tabUtenti">
                                                                    <table class="table">
                                                                      <thead>
                                                                            <tr>
                                                                              <th scope="col">Nome file</th>
                                                                              <th scope="col">Data</th>
                                                                              <th scope="col"></th>
                                                                            </tr>
                                                                      </thead>
                                                                      <tbody>
                                                                        <?php 
                                                                            $contatore = 0;
                                                                            foreach($fileCsv as $file) {
                                                                                if($file!="." && $file!=".." && strpos($file,"_utenti")>0) {
                                                                                    $contatore ++;
                                                                                    if($contatore>=$primoElemento && $contatore<=$ultimoElemento) {
                                                                                        
                                                                        ?>
                                                                                <tr>
                                                                                    <td><?php echo $file ?></td>
                                                                                    <td><?php echo date("d/m/Y H:i", filemtime("../../../file/csv/$file")); ?></td>
                                                                                    <td>
                                                                                        <div class="btn-group azioni" role="group" aria-label="Azioni">
                                                                                            <a class="btn visualizza" data-toggle="tooltip" data-placement="bottom" title="Scarica" href="<?php echo "../../../file/csv/$file" ?>"><i class="fas fa-download"></i></a>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                        <?php
                                                                                    }
                                                                                }
                                                                            }
                                                                        ?>
                                                                      </tbody>
                                                                    </table>
                                                                    <?php 
                                                                        $numeroFile = contaFile($fileCsv,"_utenti");
                                                                        if($numeroFile>=$elementiPerPagina) {
                                                                            $totalePagine = round($numeroFile/$elementiPerPagina);
                                                                    ?>
                                                                        <nav aria-label="Paginazione">
                                                                            <ul class="pagination">
                                                                                <li class="page-item disabled">
                                                                                    <a class="page-link" href="#" aria-label="Previous">
                                                                                          <span aria-hidden="true">«</span>
                                                                                    </a>
                                                                                </li>
                                                                                <?php 
                                                                                    for($i=1;$i<=$totalePagine;$i++) {
                                                                                ?>
                                                                                        <li class="page-item <?php echo(($paginaCorrente==$i) ? "active" : "") ?>">
                                                                                            <a class="page-link" href="index.php?tipoFile=_utenti&pag=<?php echo $i ?>"><?php echo $i ?></a>
                                                                                        </li>
                                                                                <?php
                                                                                    }
                                                                                ?>
                                                                                <li class="page-item disabled">
                                                                                    <a class="page-link" href="index.php?elementiPerPagina=25&amp;pag=.2" aria-label="Next">
                                                                                          <span aria-hidden="true">»</span>
                                                                                    </a>
                                                                                </li>
                                                                            </ul>
                                                                        </nav>
                                                                    <?php   
                                                                        }
                                                                    ?>
                                                            </div>
                                                            
                                                            <div class="tab-pane fade px-0 pb-0" id="tabAspetto">
                                                                <table class="table">
                                                                  <thead>
                                                                        <tr>
                                                                          <th scope="col">Nome file</th>
                                                                          <th scope="col">Data</th>
                                                                          <th scope="col"></th>
                                                                        </tr>
                                                                  </thead>
                                                                  <tbody>
                                                                    <?php 
                                                                        $contatore = 0;
                                                                        foreach($fileCsv as $file) {
                                                                            if($file!="." && $file!=".." && strpos($file,"_configurazioniAspetto")>0) {
                                                                                $contatore ++;
                                                                                if($contatore>=$primoElemento && $contatore<=$ultimoElemento) {
                                                                    ?>
                                                                            <tr>
                                                                                <td><?php echo $file ?></td>
                                                                                <td><?php echo date("d/m/Y H:i", filemtime("../../../file/csv/$file")); ?></td>
                                                                                <td>
                                                                                    <div class="btn-group azioni" role="group" aria-label="Azioni">
                                                                                        <a class="btn visualizza" data-toggle="tooltip" data-placement="bottom" title="Scarica" href="<?php echo "../../../file/csv/$file" ?>"><i class="fas fa-download"></i></a>
                                                                                    </div>
                                                                                </td>
                                                                            </tr>
                                                                    <?php
                                                                                }
                                                                            }
                                                                            
                                                                            if($contatore>=$ultimoElemento) {
                                                                                break;  
                                                                            }
                                                                        }
                                                                    ?>

                                                                  </tbody>
                                                                </table>

                                                                <?php 
                                                                    $numeroFile = contaFile($fileCsv,"_configurazioniAspetto");
                                                                    if($numeroFile>=$elementiPerPagina) {
                                                                        $totalePagine = round($numeroFile/$elementiPerPagina);
                                                                ?>
                                                                    <nav aria-label="Paginazione">
                                                                        <ul class="pagination">
                                                                            <li class="page-item disabled">
                                                                                <a class="page-link" href="#" aria-label="Previous">
                                                                                      <span aria-hidden="true">«</span>
                                                                                </a>
                                                                            </li>
                                                                            <?php 
                                                                                for($i=1;$i<=$totalePagine;$i++) {
                                                                            ?>
                                                                                    <li class="page-item <?php echo(($paginaCorrente==$i) ? "active" : "") ?>">
                                                                                        <a class="page-link" href="index.php?tipoFile=_configurazioniAspetto&pag=<?php echo $i ?>"><?php echo $i ?></a>
                                                                                    </li>
                                                                            <?php
                                                                                }
                                                                            ?>
                                                                            <li class="page-item disabled">
                                                                                <a class="page-link" href="gestionePagine.php?elementiPerPagina=25&amp;pag=.2" aria-label="Next">
                                                                                      <span aria-hidden="true">»</span>
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </nav>
                                                                <?php   
                                                                    }
                                                                ?>
                                                            </div>
                                                        </div>
                                                </div>
                                            </div>
                                        </div>
                                </div>
                        </div><!-- /Colonna principale -->
                </div>
        </div>
    </main>

    <?php 
        include "../../include/footer.php";
        
        include "../include/modal/cambiaPassword.php";
        
        include "../../include/modal/modalMenuComponenti.php";
                
        include "../../componenti/include/jsBaseComponenti.php";
        
        function contaFile($fileCsv,$stringaFile) {
            $numeroFile = 0;
            foreach($fileCsv as $file) {
                if($file!="." && $file!=".." && strpos($file,"$stringaFile")>0) {
                    $numeroFile++;
                }
            }
            return $numeroFile;
        }
    ?>
        <script>
            function mostraSelectGruppi() {
                var tabellaImportazione = document.getElementById("tabellaImportazione").value;
                
                if(tabellaImportazione == "geec_utenti") { 
                    document.getElementById("divSelectGruppo").className = "form-group";
                }
                else { 
                    document.getElementById("divSelectGruppo").className = "d-none";
                }
            }
        </script>
	  
  </body>
</html>
